package graphics;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import misc.Debug;

/**
 * SliderFrame is a base class to simplify the development of user interface
 * objects that provide a set of sliders and an "Close Window" button.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
public class SliderFrame extends Frame {
	private protected Button okButton;

/**
 * @param name The name for the window.
 * @param okButtonRow The number of last row for "Close Window" button.
 * @param totalColumns The total number of columns in the window. It's needed
 *                     for internal calculations.
 */
	protected SliderFrame( String name, int okButtonRow, int totalColumns ) {
		super( name );
		GridBagLayout layout = new GridBagLayout();
		setLayout( layout );
		okButton = new Button( "Close Window" );
		constrain( this, okButton, 0, okButtonRow, totalColumns, 1, GridBagConstraints.NONE,
		GridBagConstraints.CENTER, 0.0, 0.0 );
	}

/**
 * The method constrain simplifies the layout of a window. See documentation
 * on GridBagConstraints to see how it works
 */
	protected void constrain( Container container, Component component,
				int gridx, int gridy, int gridwidth, int gridheight,
				int fill, int anchor, double weightx, double weighty ) {

		GridBagConstraints c = new GridBagConstraints();
		c.gridx = gridx;
		c.gridy = gridy;
		c.gridwidth = gridwidth;
		c.gridheight = gridheight;
		c.fill = fill;
		c.anchor = anchor;
		c.weightx = weightx;
		c.weighty = weighty;
		c.insets = new Insets( 2, 2, 2, 2 );
		((GridBagLayout)container.getLayout()).setConstraints( component, c );
		container.add( component );
	}

/**
 * Overrides action() of class Component.
 */
	public boolean action( Event e, Object arg ) {
		if ( e.target == okButton ) {
			hide();
			return true;
		}
		return super.action( e, arg );
	}

	public synchronized void finish() {
		hide();
		dispose();
	}

	protected void finalize() {
		Debug.outa("SliderFrame.finalize: called");
		try { super.finalize(); } catch ( Throwable _x ) { ; }
	}
} // End of class SliderFrame
